/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.conditions;

import com.google.gson.JsonObject;
import java.util.List;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.api.data.conditions.ILoadConditionSerializer;
import net.darkhax.bookshelf.api.registry.IRegistryReader;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class LoadConditionRegistry<T>
implements ILoadConditionSerializer<ILoadCondition> {
    public static final LoadConditionRegistry<Block> BLOCK = new LoadConditionRegistry<Block>(Services.REGISTRIES.blocks());
    public static final LoadConditionRegistry<Item> ITEM = new LoadConditionRegistry<Item>(Services.REGISTRIES.items());
    public static final LoadConditionRegistry<Enchantment> ENCHANTMENT = new LoadConditionRegistry<Enchantment>(Services.REGISTRIES.enchantments());
    public static final LoadConditionRegistry<PaintingVariant> PAINTING = new LoadConditionRegistry<PaintingVariant>(Services.REGISTRIES.paintings());
    public static final LoadConditionRegistry<MobEffect> MOB_EFFECT = new LoadConditionRegistry<MobEffect>(Services.REGISTRIES.mobEffects());
    public static final LoadConditionRegistry<Potion> POTION = new LoadConditionRegistry<Potion>(Services.REGISTRIES.potions());
    public static final LoadConditionRegistry<Attribute> ATTRIBUTE = new LoadConditionRegistry<Attribute>(Services.REGISTRIES.attributes());
    public static final LoadConditionRegistry<EntityType<?>> ENTITY_TYPE = new LoadConditionRegistry(Services.REGISTRIES.entities());
    public static final LoadConditionRegistry<BlockEntityType<?>> BLOCK_ENTITY_TYPE = new LoadConditionRegistry(Services.REGISTRIES.blockEntities());
    private final IRegistryReader<T> registry;

    public LoadConditionRegistry(IRegistryReader<T> registry) {
        this.registry = registry;
    }

    @Override
    public ILoadCondition fromJson(JsonObject json) {
        List<ResourceLocation> ids = Serializers.RESOURCE_LOCATION.fromJSONList(json, "values");
        return () -> {
            for (ResourceLocation regId : ids) {
                if (this.registry.get(regId) != null) continue;
                return false;
            }
            return true;
        };
    }
}

